VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "MemAllocation"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

'------------------------------------------------------------------
' Name : Memory Allocation
'
' Purpose : Purpose an interface to alloc memory
'           This classe can stock standard type (integer, string, long, ...)
'           or object (class module instanciate)
'
' Methods :
'    1) Add                 Add an standard type or an object
'    2) Clear               Clear all information
'    3) RemoveCurrent       Remove the current item
'    4) RemoveKey           Remove the item with this key
'    5) RemoveIndex         Remove the item with this index
'    6) ItemCurrent         Return the current item
'    7) ItemKey             Return the item with this key
'    8) ItemIndex           Return the item with this index
'    9) FirstItem           Go to the first item
'   10) LastItem            Go to the last item
'   11) NextItem            Go to the next item
'   12) PreviousItem        Go to the previous item
'   13) Index               Return or change the current index
'   14) Count               Return the number of item
'   15) IsObjectCurrent     Indicates if the current item is an object
'   16) IsObjectKey         Indicates if the item with this key is an object
'   17) IsObjectIndex       Indicates if the item with this index is an object
'   18) IsItemKey           Is it an item with this key ?
'
' review : 16/Mai/2001 by Alexandre Delavanne
'------------------------------------------------------------------

Const KEY_PREFIX = "Key"

Const APPLICATION_NAME = "MemAllocation"

Const NBR_ERROR_UNEXPECTED = vbObjectError
Const MSG_ERROR_UNEXPECTED = "Unexpected error"
Const NBR_ERROR_NO_KEY = vbObjectError + 1
Const MSG_ERROR_NO_KEY = "No information is associated to this key"
Const NBR_ERROR_DUPLICATE_KEY = vbObjectError + 2
Const MSG_ERROR_DUPLICATE_KEY = "The key already exists"
Const NBR_ERROR_NO_INDEX = vbObjectError + 3
Const MSG_ERROR_NO_INDEX = "No information is associated to this index"
Const NBR_ERROR_REMOVE = vbObjectError + 4
Const MSG_ERROR_REMOVE = "Error on removing one element of the collection"
Const NBR_ERROR_NO_ITEM = vbObjectError + 5
Const MSG_ERROR_NO_ITEM = "The collection is empty"

Private mo_Informations As Collection
Private mo_TypeOfData As Collection

Private mi_CurrentIndex As Integer

Property Get Count() As Integer
'------------------------------------------------------------------
' Name : Count
'
' Purpose : Return the number of item
'
' Parameters : None
'
' Return :
'       The number of item
'
' review : 24/Nov/2000 by AD
'------------------------------------------------------------------

    Count = mo_Informations.Count
End Property

Property Get Index() As Integer
'------------------------------------------------------------------
' Name : Index
'
' Purpose : Return the current index
'
' Parameters : None
'
' Return :
'       Return the current index
'
' review : 24/Nov/2000 by AD
'------------------------------------------------------------------
    Index = mi_CurrentIndex
End Property

Property Let Index(li_NewIndex As Integer)
'------------------------------------------------------------------
' Name : Index
'
' Purpose : Set the current index
'
' Parameters :
'       li_NewIndex         The index to set as current
'
' Return : None
'
' review : 24/Nov/2000 by AD
'------------------------------------------------------------------
    
    On Error GoTo Index_Err
    
    If li_NewIndex > mo_Informations.Count Or li_NewIndex < 1 Then GoTo Index_Err
    
    mi_CurrentIndex = li_NewIndex
    
    Exit Property
    
Index_Err:
    Err.Raise NBR_ERROR_NO_INDEX, APPLICATION_NAME, MSG_ERROR_NO_INDEX
    
End Property

Property Get IsObjectCurrent() As Boolean
'------------------------------------------------------------------
' Name : IsObjectCurrent
'
' Purpose : Indicates if the current item is an object
'
' Parameters : None
'
' Return :
'       OK if it's an object or KO
'
' review : 24/Nov/2000 by AD
'------------------------------------------------------------------

    IsObjectCurrent = False

    On Error GoTo IsObjectCurrent_Err

    If mo_TypeOfData(mi_CurrentIndex) = "Object" Then
        IsObjectCurrent = True
    End If
    
    Exit Property
    
IsObjectCurrent_Err:
    Err.Raise NBR_ERROR_NO_INDEX, APPLICATION_NAME, MSG_ERROR_NO_INDEX
 
End Property

Property Get IsObjectIndex(li_Index As Integer) As Boolean
'------------------------------------------------------------------
' Name : IsObjectIndex
'
' Purpose : Indicates if the item with this index is an object
'
' Parameters :
'       li_Index        The index to test
'
' Return :
'       OK if it's an object or KO
'
' review : 24/Nov/2000 by AD
'------------------------------------------------------------------
    
    IsObjectIndex = False
    
    On Error GoTo IsObjectIndex_Err
    
    If mo_TypeOfData(li_Index) = "Object" Then
        IsObjectIndex = True
    End If

    Exit Property
    
IsObjectIndex_Err:
    Err.Raise NBR_ERROR_NO_INDEX, APPLICATION_NAME, MSG_ERROR_NO_INDEX

End Property

Property Get IsObjectKey(lv_Key As Variant) As Boolean
'------------------------------------------------------------------
' Name : IsObjectKey
'
' Purpose : Indicates if the item with this key is an object
'
' Parameters :
'       lv_Key          The key to test
'
' Return :
'       OK if it's an object or KO
'
' review : 24/Nov/2000 by AD
'------------------------------------------------------------------
Dim ls_Key As String

    IsObjectKey = False

    On Error GoTo IsObjectKey_Err1

    ls_Key = KEY_PREFIX + CStr(lv_Key)
    
    On Error GoTo IsObjectKey_Err2
    
    If mo_TypeOfData(ls_Key) = "Object" Then
        IsObjectKey = True
    End If
    
    Exit Property
    
IsObjectKey_Err1:
    Err.Raise NBR_ERROR_UNEXPECTED, APPLICATION_NAME, MSG_ERROR_UNEXPECTED

IsObjectKey_Err2:
    Err.Raise NBR_ERROR_NO_KEY, APPLICATION_NAME, MSG_ERROR_NO_KEY
    
End Property

Public Sub Clear()
'------------------------------------------------------------------
' Name : Clear
'
' Purpose : Delete all items
'
' Parameters : None
'
' Return : None
'
' review : 24/Nov/2000 by AD
'------------------------------------------------------------------

Dim i As Integer

    On Error GoTo Clear_Err

    For i = mo_Informations.Count To 1 Step -1
        mo_Informations.Remove i
        mo_TypeOfData.Remove i
    Next

    mi_CurrentIndex = 1

    Exit Sub

Clear_Err:
    Err.Raise NBR_ERROR_REMOVE, APPLICATION_NAME, MSG_ERROR_REMOVE

End Sub

Public Function Add(ByRef lv_Information As Variant, Optional ByVal li_Index, Optional ByVal lv_Key, Optional ByVal lb_After As Boolean = False) As Boolean
'------------------------------------------------------------------
' Name : Add
'
' Purpose : Add an item to the list
'
' Parameters :
'       lv_Information      The item
'       li_Index            It's position (Optional)
'       lv_Key              It's key (Optional)
'       lb_After            It's position after or before (default) li_Index
'
' Return :
'       OK if success or KO
'
' review : 24/Nov/2000 by AD
'------------------------------------------------------------------
Dim ls_Key As String
Dim ls_TypeOfData As String

    Add = False

    On Error GoTo Add_Err

    If IsObject(lv_Information) Then
        ls_TypeOfData = "Object"
    Else
        ls_TypeOfData = "Other"
    End If

    If IsMissing(lv_Key) Then
        If IsMissing(li_Index) Or mo_Informations.Count = 0 Then
            mo_Informations.Add lv_Information
            mo_TypeOfData.Add ls_TypeOfData
        Else
            If lb_After Then
                mo_Informations.Add lv_Information, , , li_Index
                mo_TypeOfData.Add ls_TypeOfData, , , li_Index
            Else
                mo_Informations.Add lv_Information, , li_Index
                mo_TypeOfData.Add ls_TypeOfData, , li_Index
            End If
        End If
    Else
        ls_Key = KEY_PREFIX + CStr(lv_Key)
        If IsMissing(li_Index) Or mo_Informations.Count = 0 Then
            mo_Informations.Add lv_Information, ls_Key
            mo_TypeOfData.Add ls_TypeOfData, ls_Key
        Else
            If lb_After Then
                mo_Informations.Add lv_Information, ls_Key, , li_Index
                mo_TypeOfData.Add ls_TypeOfData, ls_Key, , li_Index
            Else
                mo_Informations.Add lv_Information, ls_Key, li_Index
                mo_TypeOfData.Add ls_TypeOfData, ls_Key, li_Index
            End If
        End If
    End If

    Add = True
    
    Exit Function
    
Add_Err:

    If Err.Number = 457 Then
        Err.Raise NBR_ERROR_DUPLICATE_KEY, APPLICATION_NAME, MSG_ERROR_DUPLICATE_KEY
    Else
        Err.Raise Err.Number
    End If

End Function

Public Function RemoveKey(ByVal lv_Key As Variant) As Boolean
'------------------------------------------------------------------
' Name : RemoveKey
'
' Purpose : Remove the item with this key
'
' Parameters :
'       lv_Key          The key to remove
'
' Return :
'       OK if success or KO
'
' review : 24/Nov/2000 by AD
'------------------------------------------------------------------
Dim ls_Key As String
Dim ls_ObjectType As String

    RemoveKey = False

    On Error GoTo RemoveKey_Err2

    ls_Key = KEY_PREFIX + CStr(lv_Key)
    
    On Error GoTo RemoveKey_Err1

    ls_ObjectType = mo_TypeOfData.Item(ls_Key)

    On Error GoTo RemoveKey_Err3
    
    mo_Informations.Remove ls_Key
    mo_TypeOfData.Remove ls_Key

    RemoveKey = True

    If mi_CurrentIndex > mo_Informations.Count Then
        LastItem
    End If

    Exit Function
    
RemoveKey_Err1:
    Err.Raise NBR_ERROR_NO_KEY, APPLICATION_NAME, MSG_ERROR_NO_KEY
    
RemoveKey_Err2:
    Err.Raise NBR_ERROR_UNEXPECTED, APPLICATION_NAME, MSG_ERROR_UNEXPECTED
    
RemoveKey_Err3:
    Err.Raise NBR_ERROR_REMOVE, APPLICATION_NAME, MSG_ERROR_REMOVE
    
End Function

Public Function RemoveCurrent() As Boolean
'------------------------------------------------------------------
' Name : RemoveCurrent
'
' Purpose : Remove the current item
'
' Parameters : None
'
' Return :
'       OK if success or KO
'
' review : 24/Nov/2000 by AD
'------------------------------------------------------------------

    RemoveCurrent = False

    On Error GoTo RemoveCurrent_Err
    
    If mi_CurrentIndex > mo_Informations.Count Then GoTo RemoveCurrent_Err
    
    mo_Informations.Remove mi_CurrentIndex
    mo_TypeOfData.Remove mi_CurrentIndex
    
    RemoveCurrent = True
    
    Exit Function
    
RemoveCurrent_Err:
    Err.Raise NBR_ERROR_REMOVE, APPLICATION_NAME, MSG_ERROR_REMOVE

End Function

Public Function RemoveIndex(ByVal li_Index As Integer) As Boolean
'------------------------------------------------------------------
' Name : RemoveIndex
'
' Purpose : Remove the item with this index
'
' Parameters :
'       lv_Index          The index to remove
'
' Return :
'       OK if success or KO
'
' review : 24/Nov/2000 by AD
'------------------------------------------------------------------

    RemoveIndex = False

    On Error GoTo RemoveIndex_Err
    
    mo_Informations.Remove li_Index
    mo_TypeOfData.Remove li_Index
    
    If mi_CurrentIndex > mo_Informations.Count Then
        LastItem
    End If
    
    RemoveIndex = True
    
    Exit Function
    
RemoveIndex_Err:
    Err.Raise NBR_ERROR_REMOVE, APPLICATION_NAME, MSG_ERROR_REMOVE

End Function

Public Function ItemKey(ByVal lv_Key As Variant) As Variant
'------------------------------------------------------------------
' Name : ItemKey
'
' Purpose : Return the item with this key
'
' Parameters :
'       lv_Key          The key to return
'
' Return :
'       The Item
'
' review : 24/Nov/2000 by AD
'------------------------------------------------------------------
Dim ls_Key As String
Dim ls_ObjectType As String

    On Error GoTo ItemKey_Err2
    
    ls_Key = KEY_PREFIX + CStr(lv_Key)
        
    On Error GoTo ItemKey_Err1
        
    ls_ObjectType = mo_TypeOfData.Item(ls_Key)
    
    On Error GoTo ItemKey_Err2
    
    If ls_ObjectType = "Object" Then
        Set ItemKey = mo_Informations.Item(ls_Key)
    Else
        ItemKey = mo_Informations.Item(ls_Key)
    End If
    
    Exit Function

ItemKey_Err1:
    Err.Raise NBR_ERROR_NO_KEY, APPLICATION_NAME, MSG_ERROR_NO_KEY
    
ItemKey_Err2:
    Err.Raise NBR_ERROR_UNEXPECTED, APPLICATION_NAME, MSG_ERROR_UNEXPECTED
    
End Function

Public Function ItemIndex(ByVal li_Index As Integer) As Variant
'------------------------------------------------------------------
' Name : ItemIndex
'
' Purpose : Return the item with this index
'
' Parameters :
'       li_Index        The index to return
'
' Return :
'       The item
'
' review : 24/Nov/2000 by AD
'------------------------------------------------------------------

    On Error GoTo ItemIndex_Err
    
    If mo_TypeOfData(li_Index) = "Object" Then
        Set ItemIndex = mo_Informations.Item(li_Index)
    Else
        ItemIndex = mo_Informations.Item(li_Index)
    End If
    
    Exit Function
    
ItemIndex_Err:
    Err.Raise NBR_ERROR_NO_INDEX, APPLICATION_NAME, MSG_ERROR_NO_INDEX

End Function

Public Function FirstItem() As Boolean
'------------------------------------------------------------------
' Name : FirstItem
'
' Purpose : Go to the first item
'
' Parameters : None
'
' Return :
'       OK if success or KO
'
' review : 24/Nov/2000 by AD
'------------------------------------------------------------------

    If mo_Informations.Count = 0 Then
        FirstItem = False
        mi_CurrentIndex = 0
        Exit Function
    End If
    
    mi_CurrentIndex = 1
    
    FirstItem = True
        
End Function


Public Function LastItem() As Boolean
'------------------------------------------------------------------
' Name : LastItem
'
' Purpose : Go to the last item
'
' Parameters : None
'
' Return :
'       OK if success or KO
'
' review : 24/Nov/2000 by AD
'------------------------------------------------------------------

    If mo_Informations.Count = 0 Then
        LastItem = False
        mi_CurrentIndex = 0
        Exit Function
    End If
    
    mi_CurrentIndex = mo_Informations.Count
    
    LastItem = True
    
End Function

Public Function NextItem() As Boolean
'------------------------------------------------------------------
' Name : NextItem
'
' Purpose : Go to the next item
'
' Parameters : None
'
' Return :
'       OK if success or KO
'
' review : 24/Nov/2000 by AD
'------------------------------------------------------------------

    If mi_CurrentIndex >= mo_Informations.Count Then
        NextItem = False
        mi_CurrentIndex = mo_Informations.Count
        Exit Function
    End If
    
    If mi_CurrentIndex = 0 Then
        NextItem = False
        Exit Function
    End If
        
    mi_CurrentIndex = mi_CurrentIndex + 1
    
    NextItem = True

End Function

Public Function PreviousItem() As Boolean
'------------------------------------------------------------------
' Name : PreviousItem
'
' Purpose : Go to the previous item
'
' Parameters : None
'
' Return :
'       OK if success or KO
'
' review : 24/Nov/2000 by AD
'------------------------------------------------------------------

    If mi_CurrentIndex = 1 Or mi_CurrentIndex = 0 Then
        PreviousItem = False
        Exit Function
    End If
    
    mi_CurrentIndex = mi_CurrentIndex - 1
    
    PreviousItem = True

End Function

Public Function ItemCurrent() As Variant
'------------------------------------------------------------------
' Name : ItemCurrent
'
' Purpose : Return the current Item
'
' Parameters : None
'
' Return :
'       The item
'
' review : 24/Nov/2000 by AD
'------------------------------------------------------------------

    On Error GoTo ItemCurrent_Err
    
    If mi_CurrentIndex > mo_Informations.Count Then GoTo ItemCurrent_Err
    
    On Error GoTo ItemCurrent_Err1
    
    If mo_TypeOfData(mi_CurrentIndex) = "Object" Then
        Set ItemCurrent = mo_Informations.Item(mi_CurrentIndex)
    Else
        ItemCurrent = mo_Informations.Item(mi_CurrentIndex)
    End If
    
    Exit Function
    
ItemCurrent_Err:
    Err.Raise NBR_ERROR_NO_INDEX, APPLICATION_NAME, MSG_ERROR_NO_INDEX

ItemCurrent_Err1:
    Err.Raise NBR_ERROR_UNEXPECTED, APPLICATION_NAME, MSG_ERROR_UNEXPECTED

End Function

Public Function IsItemKey(ByVal lv_Key As Variant) As Boolean
'------------------------------------------------------------------
' Name : FindItemKey
'
' Purpose : Is it an item with this key ?
'
' Parameters :
'       lv_Key          The key to search
'
' Return :
'       if found, true
'       if not found, false
'
' review : 16/Mai/2001 by AD
'------------------------------------------------------------------
Dim ls_Key As String
Dim ls_ObjectType As String

    IsItemKey = False

    On Error GoTo IsItemKey_Err2
    
    ls_Key = KEY_PREFIX + CStr(lv_Key)
        
    On Error GoTo IsItemKey_Err1

    ls_ObjectType = mo_TypeOfData.Item(ls_Key)
    
    IsItemKey = True
    
    Exit Function

IsItemKey_Err1:
    Exit Function
    
IsItemKey_Err2:
    Err.Raise NBR_ERROR_UNEXPECTED, APPLICATION_NAME, MSG_ERROR_UNEXPECTED
    
End Function

Private Sub Class_Initialize()
'------------------------------------------------------------------
' Name : Class_Initialize
'
' Purpose : Initialize the class
'
' Parameters : None
'
' Return : None
'
' review : 24/Nov/2000 by AD
'------------------------------------------------------------------

    On Error GoTo Class_Initialize_Err

    Set mo_Informations = New Collection
    Set mo_TypeOfData = New Collection
    
    mi_CurrentIndex = 0
    
    Exit Sub
    
Class_Initialize_Err:
    Err.Raise NBR_ERROR_UNEXPECTED, APPLICATION_NAME, MSG_ERROR_UNEXPECTED
    
End Sub

Private Sub Class_Terminate()
'------------------------------------------------------------------
' Name : Class_Terminate
'
' Purpose : Terminate the class, remove all items
'
' Parameters : None
'
' Return : None
'
' review : 24/Nov/2000 by AD
'------------------------------------------------------------------

    On Error GoTo Class_Terminate_Err

    Clear
    Set mo_Informations = Nothing
    Set mo_TypeOfData = Nothing
    
    Exit Sub
    
Class_Terminate_Err:
    If Err.Number <> 0 Then Err.Raise Err.Number
    Err.Raise NBR_ERROR_UNEXPECTED, APPLICATION_NAME, MSG_ERROR_UNEXPECTED

End Sub
